# Third‑Party Software and Models

This project integrates external services and model families. Their licenses and terms apply when you use them. Review each before use in your environment.

## Services

- Ollama
  - Site: https://ollama.com/
  - Repo: https://github.com/ollama/ollama
  - Notes: Provides local LLM runtime; models have their own licenses.

- Kokoro TTS FastAPI
  - Repo: https://github.com/remsky/kokoro-fastapi
  - Images:
    - CPU (ONNX): ghcr.io/remsky/kokoro-fastapi-cpu
    - GPU (CUDA): ghcr.io/remsky/kokoro-fastapi-gpu
  - Notes: Check the repo/image pages for license and usage terms.

## Model families (examples)

- Meta Llama models
  - https://llama.meta.com/
  - License: Meta Llama license.

- Google Gemma
  - https://ai.google.dev/gemma
  - License: Gemma license.

- IBM Granite
  - https://ibm.github.io/granite/
  - License: IBM terms.

## Important

- Each model may have different rights and restrictions (e.g., commercial use, redistribution, weights hosting).
- Your use of these models/services must comply with their respective licenses in addition to the Apache-2.0 license of this application’s source code.
